/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntityParrotTFC
extends EntityParrot
implements IAnimalTFC,
ILivestock {
    private static final int DAYS_TO_ADULTHOOD = 96;
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityParrotTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BIRTHDAY = EntityDataManager.func_187226_a(EntityParrotTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> FAMILIARITY = EntityDataManager.func_187226_a(EntityParrotTFC.class, (DataSerializer)DataSerializers.field_187193_c);
    private long lastFed;
    private long lastFDecay;
    private boolean fertilized;
    private long matingTime;
    private long lastDeath;

    public EntityParrotTFC(World world) {
        this(world, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityAnimalTFC.getRandomGrowth(96, 0));
    }

    public EntityParrotTFC(World world, IAnimalTFC.Gender gender, int birthDay) {
        super(world);
        this.setGender(gender);
        this.setBirthDay(birthDay);
        this.setFamiliarity(0.0f);
        this.func_70873_a(0);
        this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
        this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.fertilized = false;
    }

    public boolean func_191994_f(@Nonnull EntityPlayer player) {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 100 == 0) {
            this.func_98054_a(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            float familiarity;
            if (this.lastFDecay > -1L && this.lastFDecay + 1L < CalendarTFC.PLAYER_TIME.getTotalDays() && (familiarity = this.getFamiliarity()) < 0.3f) {
                familiarity = (float)((double)familiarity - 0.02 * (double)(CalendarTFC.PLAYER_TIME.getTotalDays() - this.lastFDecay));
                this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
                this.setFamiliarity(familiarity);
            }
            if (this.getGender() == IAnimalTFC.Gender.MALE && this.isReadyToMate()) {
                this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
                EntityAnimalTFC.findFemaleMate(this);
            }
            if (this.getAge() != IAnimalTFC.Age.OLD || this.lastDeath < CalendarTFC.PLAYER_TIME.getTotalDays()) {
                // empty if block
            }
        }
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b()) {
            if (itemstack.func_77973_b() == Items.field_151063_bx) {
                return super.func_184645_a(player, hand);
            }
            if (this.isFood(itemstack) && player.func_70093_af() && this.getAdultFamiliarityCap() > 0.0f && this.isHungry()) {
                IFood cap = (IFood)itemstack.getCapability(CapabilityFood.CAPABILITY, null);
                if (cap != null && cap.isRotten()) {
                    return false;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.lastFDecay = this.lastFed = CalendarTFC.PLAYER_TIME.getTotalDays();
                    this.func_175505_a(player, itemstack);
                    if (this.getAge() == IAnimalTFC.Age.CHILD || this.getFamiliarity() < this.getAdultFamiliarityCap()) {
                        float familiarity = this.getFamiliarity() + 0.06f;
                        if (this.getAge() != IAnimalTFC.Age.CHILD) {
                            familiarity = Math.min(familiarity, this.getAdultFamiliarityCap());
                        }
                        this.setFamiliarity(familiarity);
                    }
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.AMBIENT, 1.0f, 1.0f);
                    TFCTriggers.FAMILIARIZATION_TRIGGER.trigger((EntityPlayerMP)player, this);
                }
                return true;
            }
        }
        if (this.getFamiliarity() < 0.3f) {
            return false;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && BlocksTFC.isGround(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    public boolean func_70878_b(@Nonnull EntityAnimal otherAnimal) {
        return false;
    }

    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        return new EntityParrotTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GENDER, (Object)true);
        this.func_184212_Q().func_187214_a(BIRTHDAY, (Object)0);
        this.func_184212_Q().func_187214_a(FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("gender", this.getGender().toBool());
        nbt.func_74768_a("birth", this.getBirthDay());
        nbt.func_74772_a("fed", this.lastFed);
        nbt.func_74772_a("decay", this.lastFDecay);
        nbt.func_74757_a("fertilized", this.fertilized);
        nbt.func_74772_a("mating", this.matingTime);
        nbt.func_74776_a("familiarity", this.getFamiliarity());
        nbt.func_74772_a("lastDeath", this.lastDeath);
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGender(IAnimalTFC.Gender.valueOf(nbt.func_74767_n("gender")));
        this.setBirthDay(nbt.func_74762_e("birth"));
        this.lastFed = nbt.func_74763_f("fed");
        this.lastFDecay = nbt.func_74763_f("decay");
        this.matingTime = nbt.func_74763_f("mating");
        this.fertilized = nbt.func_74767_n("fertilized");
        this.setFamiliarity(nbt.func_74760_g("familiarity"));
        this.lastDeath = nbt.func_74763_f("lastDeath");
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_PARROT;
    }

    @Override
    public IAnimalTFC.Gender getGender() {
        return IAnimalTFC.Gender.valueOf((Boolean)this.field_70180_af.func_187225_a(GENDER));
    }

    @Override
    public void setGender(IAnimalTFC.Gender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender.toBool());
    }

    @Override
    public int getBirthDay() {
        return (Integer)this.field_70180_af.func_187225_a(BIRTHDAY);
    }

    @Override
    public void setBirthDay(int value) {
        this.field_70180_af.func_187227_b(BIRTHDAY, (Object)value);
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.4f;
    }

    @Override
    public float getFamiliarity() {
        return ((Float)this.field_70180_af.func_187225_a(FAMILIARITY)).floatValue();
    }

    @Override
    public void setFamiliarity(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.field_70180_af.func_187227_b(FAMILIARITY, (Object)Float.valueOf(value));
    }

    @Override
    public boolean isFertilized() {
        return this.fertilized;
    }

    @Override
    public void setFertilized(boolean value) {
        this.fertilized = value;
    }

    @Override
    public int getDaysToAdulthood() {
        return 96;
    }

    @Override
    public int getDaysToElderly() {
        return 0;
    }

    @Override
    public boolean isReadyToMate() {
        return false;
    }

    @Override
    public boolean isHungry() {
        return this.lastFed < CalendarTFC.PLAYER_TIME.getTotalDays();
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.OVIPAROUS;
    }

    @Override
    public TextComponentTranslation getAnimalName() {
        String entityString = EntityList.func_75621_b((Entity)this);
        return new TextComponentTranslation("tfc.animal." + entityString + "." + this.getGender().name().toLowerCase(), new Object[0]);
    }

    public void func_70873_a(int age) {
        super.func_70873_a(0);
    }

    public boolean func_70631_g_() {
        return this.getAge() == IAnimalTFC.Age.CHILD;
    }

    public void func_98054_a(boolean child) {
        double ageScale = 1.0 / (2.0 - this.getPercentToAdulthood());
        this.func_98055_j((float)ageScale);
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getAnimalName().func_150254_d();
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.TEMPERATE_FOREST && biomeType != BiomeHelper.BiomeType.TROPICAL_FOREST)) {
            return ConfigTFC.Animals.PARROT.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.ELDER_AND_POPULATION;
    }

    @Override
    public int getMinGroupSize() {
        return 1;
    }

    @Override
    public int getMaxGroupSize() {
        return 4;
    }
}

